/* ============ */
/* colsntst.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <clsndefs.h>
#include <miscdefs.h>

#define	NUM_PROBS	100
static	double	ClsnProbs[NUM_PROBS];

static	CLSN_DATA_STRU  ClsnData;
static	INIT_DATA_STRU  InitialData;
/* ====================================================================	*/
/* CollisionTest - Applies the Collision Test 				*/
/* ==================================================================== */
void
main()
{
    /* ----------------------------------------------------------- */
    /* The collision test is applied when the number of categories */
    /* is much greater than the number of observations.		   */
    /* ----------------------------------------------------------- */

    int     k;
    double  KnMinusProb, KnMinusStat, KnPlusProb, KnPlusStat;

    AbortGracefully();			/* Make ^C act reasonably */

    printf("\tC O L L I S I O N  T E S T\n\n");
    GetInitialData(&InitialData);
    fprintf(stderr, "\n"); fflush(NULL);

    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("Starting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT)(-1)) ?
		" (Unsigned Integer Part of Time of Day)" : "");

    printf("Generator     = %s\n", InitialData.GenName);

    ClsnData.RandFun = InitialData.RandFun;

    SetCollisionControls(&ClsnData);

    printf("\nNumber of Balls = %u, Number of Urns = %ld\n",
	ClsnData.NumObs, ClsnData.NumCategories);
    printf("\nCalculating Collision-Probability Table\n");

    CalcCollisionProbs(&ClsnData);

    printf("\n   collisions <=");
    for (k = TMAX-2; k >= 0; --k)
    {
	printf("%7d",	ClsnData.ClsnStats[k]);
    }
    printf("\nwith probability");
    for (k = TMAX-2; k >= 0; --k)
    {
	printf("%7.3f", ClsnData.ClsnProbs[k]);
    }
    printf("\n\n");

    /* -------------------------- */
    /* Generate Random Numbers,   */
    /* Calculate Probability Data */
    /* -------------------------- */
    for (k = 0; k < NUM_PROBS; ++k)
    {
	GetCollisionData(&ClsnData);
	ClsnProbs[k] = ClsnData.HitProb;

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    k+1, NUM_PROBS, ClsnData.NumVariates);

	P(printf("Number of Collisions      = %u\n",
		ClsnData.NumHits));
	P(printf("Corresponding Probability = %.3f\n",
		ClsnData.HitProb));
    }

    /* -------------------------------------------------------- */
    /* Calculate K-S on Chi-Square Statistics and Probabilities */
    /* -------------------------------------------------------- */
    fprintf(stderr, "\n"); fflush(NULL);
    KSCalc(ClsnProbs, NUM_PROBS,
		&KnPlusStat, &KnPlusProb,
 		&KnMinusStat, &KnMinusProb);

    printf("\nKolmogorov-Smirnov Statistics and Probabilities"
	" on Collision Probability Data\n");

    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnPlusStat, 100*KnPlusProb);

    printf("\tK(%d)- = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnMinusStat, 100*KnMinusProb);

    printf("\n%d-Dimensional Randomness was Tested\n", ClsnData.NumParts);
    printf("This Run Required %ld Variates\n", ClsnData.NumVariates);
}
